<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Coming Soon</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: #ffffff;
            font-family: 'Arial', sans-serif;
            overflow: hidden;
        }

        .container {
            text-align: center;
        }

        .logo {
            width: 100px;
            margin: 0 auto 20px auto;
            animation: fadeInDown 1s ease;
        }

        h1 {
            font-size: 3rem;
            color: #333333;
            margin: 0;
            animation: fadeInDown 1s ease;
        }

        p {
            font-size: 1.5rem;
            color: #555555;
            margin-top: 10px;
            animation: fadeInUp 1.5s ease;
        }

        .spinner {
            width: 50px;
            height: 50px;
            margin: 20px auto;
            border: 5px solid #FFFFFF;
            border-top: 5px solid #3333ff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        .button {
            display: inline-block;
            margin-top: 20px;
            padding: 10px 20px;
            font-size: 1rem;
            color: #ffffff;
            background-color: #3333ff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            animation: fadeInUp 2s ease;
        }

        .button:hover {
            background-color: #2980b9;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        @keyframes fadeInDown {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .fade-text {
            animation: blink 2s infinite;
        }

        @keyframes blink {
            0%, 100% { opacity: 1; }
            50% { opacity: 0; }
        }
    </style>
</head>
<body>
    <div class="container">
        <img src="logos/logo.png" alt="Logo" class="logo">
        <h1>Coming Soon</h1>
        <div class="spinner"></div>
        <p class="fade-text">We're working on something amazing!</p>
        <a href="dashboard.php" class="button">Go Home</a>
    </div>
    <script>
        function updateTime() {
            const timeElement = document.getElementById('time');
            const now = new Date();
            timeElement.textContent = `Current Time: ${now.toLocaleTimeString()}`;
        }
        setInterval(updateTime, 1000);
        updateTime();
    </script>
</body>
</html>
